package kom.itbeankit.nw.ethernet;

import java.awt.*;
import symantec.itools.awt.VerticalSlider;
import symantec.itools.awt.BorderPanel;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.nw.ethernet.*;
import kom.itbeankit.common.vcr.ControlButtonPanel;

import kom.itbeankit.nw.ethernet.BusElement;

import kom.itbeankit.nw.ethernet.Hub;
public class Hubap extends java.awt.Container implements EthernetInterface,
                                                            ClkListener,MessageListener
{
    protected AlgorithmInterface algorithm;
    protected boolean usePadField;
    protected int numOfHosts = 6;
	private java.util.Vector messageListeners=new java.util.Vector();
    protected int scenario = SCENARIO_NONE;

   

    public void setEnabled(boolean b){
        super.setEnabled(b);
        host1.setEnabled(b);
        host2.setEnabled(b);
        host3.setEnabled(b);
        host4.setEnabled(b);
        host5.setEnabled(b);
        host6.setEnabled(b);

    }

    public void doScenario(ClkEvent e){
        switch(scenario){
            case SCENARIO_NONE:
                scenarioNone(e);
            break;
            case SCENARIO_NORMAL:
                scenarioNormal(e);
            break;
            case SCENARIO_COLLISION:
                scenarioCollision(e);
            break;

            default:

        }
    }

    void scenarioNone(ClkEvent e)
    {
        if(e.isRisingEdge())
            showEfficiency();
        hub1.clkReceived(e);
        host1.clkReceived(e);
        host2.clkReceived(e);
        host3.clkReceived(e);
        if(numOfHosts>3){
            host4.clkReceived(e);
            host5.clkReceived(e);
            host6.clkReceived(e);
            hub2.clkReceived(e);
        }

    }


    void scenarioNormal(ClkEvent e)
    {

      if (numOfHosts==3)
       {
    //setNumOfHosts(6);
    //        reset();
        msg("scenario normal operation","\n"+
            "  in this scenario host3 sends"+"\n"+
            "   a frame to host1.If we had had"+"\n"+
            "a cable instead of a hub that would"+"\n"+
            "have not worked because an"+"\n"+
            "Ethernet cable needs all its ways "+"\n"+
            "out closed with a Host or with 50 ohm");
		host3.setFrameSize(FRAME_SIZE_NORMAL);
		host3.setAutoRepeat(false);
		host3.setDestinationHost(1);
        scenario = SCENARIO_NONE;
    //    scenarioNone(e);
       }
       else//{ setNumOfHosts(6);}
       if (numOfHosts==6)
            {
            msg("scenario normal operation","\n"+
            "  in this scenario host5 sends"+"\n"+
            "   a frame to host1");
		host5.setFrameSize(FRAME_SIZE_NORMAL);
		host5.setAutoRepeat(false);
		host5.setDestinationHost(1);
        scenario = SCENARIO_NONE;
            }
    }

    void scenarioCollision(ClkEvent e)
    {

     if (numOfHosts==3)
         {
      //  setNumOfHosts(6);
     //   reset();
        msg("scenario collision","\n"+
            "   in this scenario host2 and"+"\n"+
            "   host3 send frames at the same"+"\n"+
            "   time to host3 and host1");
		host3.setFrameSize(FRAME_SIZE_NORMAL);
		host3.setAutoRepeat(false);
		host2.setFrameSize(FRAME_SIZE_NORMAL);
		host2.setAutoRepeat(false);
		host2.setDestinationHost(3);
		host3.setDestinationHost(1);
        scenario = SCENARIO_NONE;

        }
       else//{ setNumOfHosts(6);}
       if (numOfHosts==6)
            {
                msg("scenario collision","\n"+
            "   in this scenario host2 and"+"\n"+
            "   host6 send frames at the same"+"\n"+
            "   time to host5 and host1");
		host6.setFrameSize(FRAME_SIZE_NORMAL);
		host6.setAutoRepeat(false);
		host2.setFrameSize(FRAME_SIZE_NORMAL);
		host2.setAutoRepeat(false);
		host2.setDestinationHost(5);
		host6.setDestinationHost(1);
        scenario = SCENARIO_NONE;
   //     scenarioNone(e);
           }
    }


    public void setScenario(int scenario){
        this.scenario = scenario;
    }

    public int getScenario(){
        return scenario;
    }

    void msg(String subject, String message){
        deliverMessage(new MessageEvent(    this,
                                            MessageEvent.DISPLAY_TYPE_TEXTAREA,
                                            MessageEvent.MSG_TYPE_INFO,
                                            subject, message));
    }

	public void deliverMessage(MessageEvent me){
	    MessageEvent event = new MessageEvent(this,me);
        for(int i=0; i<messageListeners.size();i++){
            MessageListener ml = (MessageListener)messageListeners.elementAt(i);
            ml.deliverMessage(event);
        }
	}
    public synchronized void addMessageListener(MessageListener lis)
    {
        messageListeners.addElement(lis);
    }

    public synchronized void removeMessageListener(MessageListener lis)
    {
        messageListeners.removeElement(lis);
    }

    public void setNumOfHosts(int num)
    {
        switch(num){
            case 3:
                numOfHosts = 3;
                set2ndPairVisible(false);

            break;
            case 6:
                numOfHosts = 6;
                set2ndPairVisible(true);
            break;
            default:
        }
    }

    void set2ndPairVisible(boolean b){
       host4.setVisible(b);
       host5.setVisible(b);
       host6.setVisible(b);
       hub2.setVisible(b);
       if(!b){
           host4.reset();
           host5.reset();
           host6.reset();
           hub2.reset();
       }
    }


    public int getNumOfHosts()
    {
        return numOfHosts;
    }


    public void setAlgorithm(String algorithmName)
    {
        this.algorithm = algorithm;
        host1.setAlgorithm(algorithmName);
        host2.setAlgorithm(algorithmName);
        host3.setAlgorithm(algorithmName);
        host4.setAlgorithm(algorithmName);
        host5.setAlgorithm(algorithmName);
        host6.setAlgorithm(algorithmName);

    }

    public AlgorithmInterface getAlgorithm()
    {
        return this.algorithm;
    }

	public void setUsePadField(boolean usePadField)
	{
		this.usePadField = usePadField;
        host1.setUsePadField(usePadField);
        host2.setUsePadField(usePadField);
        host3.setUsePadField(usePadField);
        host4.setUsePadField(usePadField);
        host5.setUsePadField(usePadField);
        host6.setUsePadField(usePadField);

	}

	public boolean isUsePadField()
	{
		return this.usePadField;
	}

	public Hubap()
	{
		//{{INIT_CONTROLS
		hubapPanel = new java.awt.Panel();
		hubapPanel.setLayout(null);
		hubapPanel.setBounds(0,0,425,240);
		add(hubapPanel);
		hostTopPanel = new java.awt.Panel();
		hostTopPanel.setLayout(null);
		hostTopPanel.setBounds(10,10,400,74);
		host3 = new kom.itbeankit.nw.ethernet.Host();
		host3.setID(3);
		host3.setBounds(98,0,80,74);
		hostTopPanel.add(host3);
		host3.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host5 = new kom.itbeankit.nw.ethernet.Host();
		host5.setID(5);
		host5.setBounds(230,0,80,74);
		hostTopPanel.add(host5);
		host5.setCursor(new Cursor(Cursor.HAND_CURSOR));
		hubapPanel.add(hostTopPanel);
		busPanel = new java.awt.Panel();
		busPanel.setLayout(null);
		busPanel.setBounds(80,84,260,76);
		hubapPanel.add(busPanel);
		hub1 = new kom.itbeankit.nw.ethernet.Hub();
		hub1.setHubLabel("");
		hub1.setLayout(new BorderLayout(0,0));
		hub1.setBounds(0,0,130,76);
		busPanel.add(hub1);
		hub2 = new kom.itbeankit.nw.ethernet.Hub();
		hub2.setHubLabel("");
		hub2.setLayout(new BorderLayout(0,0));
		hub2.setBounds(130,0,130,76);
		busPanel.add(hub2);
		hostBottomPanel = new java.awt.Panel();
		hostBottomPanel.setLayout(null);
		hostBottomPanel.setBounds(10,160,400,74);
		hubapPanel.add(hostBottomPanel);
		host2 = new kom.itbeankit.nw.ethernet.Host();
		host2.setOverTheBus(false);
		host2.setID(2);
		host2.setBounds(92,0,80,74);
		hostBottomPanel.add(host2);
		host2.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host4 = new kom.itbeankit.nw.ethernet.Host();
		host4.setOverTheBus(false);
		host4.setID(4);
		host4.setBounds(224,0,80,74);
		hostBottomPanel.add(host4);
		host4.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host6 = new kom.itbeankit.nw.ethernet.Host();
		host6.setOverTheBus(false);
		host6.setID(6);
		host6.setBounds(336,56,80,74);
		hubapPanel.add(host6);
		host6.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host1 = new kom.itbeankit.nw.ethernet.Host();
		host1.setBounds(0,76,80,74);
		hubapPanel.add(host1);
		host1.setCursor(new Cursor(Cursor.HAND_CURSOR));
		efficiencyPanel = new symantec.itools.awt.BorderPanel();
		try {
			efficiencyPanel.setLabel("Efficiency");
		}
		catch(java.beans.PropertyVetoException e) { }
		GridBagLayout gridBagLayout;
		gridBagLayout = new GridBagLayout();
		efficiencyPanel.setLayout(gridBagLayout);
		efficiencyPanel.setBounds(420,0,80,240);
		add(efficiencyPanel);
		performanceSlider = new symantec.itools.awt.VerticalSlider();
		try {
			performanceSlider.setMaxValue(100);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			performanceSlider.setMinValue(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			performanceSlider.setValue(100);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			performanceSlider.setTickFreq(10);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			performanceSlider.setTickStyle(symantec.itools.awt.VerticalSlider.TICK_BOTTOM);
		}
		catch(java.beans.PropertyVetoException e) { }
		performanceSlider.setBounds(5,0,20,196);
		performanceSlider.setBackground(new Color(12632256));
		GridBagConstraints gbc;
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridheight = 3;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,5,-20,0);
		gbc.ipadx = 12;
		((GridBagLayout)efficiencyPanel.getLayout()).setConstraints(performanceSlider, gbc);
		efficiencyPanel.add(performanceSlider);
		performanceSlider.setEnabled(false);
		maxLabel = new java.awt.Label("100%",Label.RIGHT);
		maxLabel.setBounds(25,0,34,23);
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)efficiencyPanel.getLayout()).setConstraints(maxLabel, gbc);
		efficiencyPanel.add(maxLabel);
		minLabel = new java.awt.Label("0%",Label.RIGHT);
		minLabel.setBounds(35,176,24,23);
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 3;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,10,0,0);
		((GridBagLayout)efficiencyPanel.getLayout()).setConstraints(minLabel, gbc);
		efficiencyPanel.add(minLabel);
		helpButton = new java.awt.Button();
		helpButton.setLabel("?");
		helpButton.setBounds(36,88,21,23);
		helpButton.setFont(new Font("Dialog", Font.BOLD, 12));
		helpButton.setForeground(new Color(255));
		helpButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 2;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,10,0,0);
		((GridBagLayout)efficiencyPanel.getLayout()).setConstraints(helpButton, gbc);
		efficiencyPanel.add(helpButton);
		helpButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		//}}

        hub1.setHubLabel("HUB1");
        hub2.setHubLabel("HUB2");

		try {
			efficiencyPanel.setLabel(EthernetTexts.EFFICIENCY_LABEL);
		}
		catch(java.beans.PropertyVetoException e) { }

	    setAlgorithm("kom.itbeankit.nw.ethernet.OnePersistentAlgorithm");
        setNumOfHosts(6);
		//{{REGISTER_LISTENERS
		SymData lSymData = new SymData();
		host1.addDataListener(lSymData);
		host2.addDataListener(lSymData);
		host3.addDataListener(lSymData);
		host5.addDataListener(lSymData);
		host4.addDataListener(lSymData);
		host6.addDataListener(lSymData);
		SymMessage lSymMessage = new SymMessage();
		host1.addMessageListener(lSymMessage);
		host2.addMessageListener(lSymMessage);
		host3.addMessageListener(lSymMessage);
		host4.addMessageListener(lSymMessage);
		host5.addMessageListener(lSymMessage);
		host6.addMessageListener(lSymMessage);
		SymAction lSymAction = new SymAction();
		helpButton.addActionListener(lSymAction);

		hub1.addDataListener(lSymData);
		hub2.addDataListener(lSymData);
		//}}
	}
	//{{DECLARE_CONTROLS
	java.awt.Panel hubapPanel;
	java.awt.Panel hostTopPanel;
	java.awt.Panel busPanel;
	kom.itbeankit.nw.ethernet.Hub hub1;
	kom.itbeankit.nw.ethernet.Hub hub2;
	java.awt.Panel hostBottomPanel;
	symantec.itools.awt.BorderPanel efficiencyPanel;
	symantec.itools.awt.VerticalSlider performanceSlider;
	java.awt.Label maxLabel;
	java.awt.Label minLabel;
	java.awt.Button helpButton;
    Host host1;
    Host host2;
    Host host3;
    Host host4;
    Host host5;
    Host host6;
	
	//}}

	/*public void paint(Graphics g){
	    super.paint(g);
        //setSize(getPreferredSize());
	    bus.setSize(ethernetPanel.getSize().width,30);
	    //panel.invalidate();
	}*/

    //Clock Functions
    public void clkReceived(ClkEvent e){
        doScenario(e);
    }
    //Clock Functions End

    public void reset(){
        hub1.reset();
        hub2.reset();

        host1.reset();
        host2.reset();
        host3.reset();
        host4.reset();
        host5.reset();
        host6.reset();


        clkReceived(new ClkEvent(this,true));
        clkReceived(new ClkEvent(this,false));
        clkReceived(new ClkEvent(this,true));
    }

    public void resetDataSize(){
		try {
			performanceSlider.setValue(100);
		}
		catch(java.beans.PropertyVetoException e) { }
        host1.resetDataSize();
        host2.resetDataSize();
        host3.resetDataSize();
        host4.resetDataSize();
        host5.resetDataSize();
        host6.resetDataSize();

    }

    public int getEfficiency(){
        double sentDataSize = 0.0;
        double receivedDataSize = 0.0;
        sentDataSize =  host1.getSentDataSize()+
                        host2.getSentDataSize()+
                        host3.getSentDataSize()+
                        host4.getSentDataSize()+
                        host5.getSentDataSize()+
                        host6.getSentDataSize();

        receivedDataSize =  host1.getReceivedDataSize()+
                            host2.getReceivedDataSize()+
                            host3.getReceivedDataSize()+
                            host4.getReceivedDataSize()+
                            host5.getReceivedDataSize()+
                            host6.getReceivedDataSize();

        double returnValue = -1;
        if(sentDataSize != 0)
            returnValue = (receivedDataSize/sentDataSize)*100;
        return (int)returnValue;
    }

    void showEfficiency(){
        int eff = getEfficiency();
        if(eff!=-1){
            try{
                performanceSlider.setValue(100-eff);
            }
            catch(Exception e){}
        }
    }

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(510,205);
				this.add(new Hubap());
				validate();
			}
		}

		new DriverFrame().show();
	}



	class SymMessage implements kom.itbeankit.common.message.MessageListener
	{
		public void deliverMessage(kom.itbeankit.common.message.MessageEvent event)
		{
				host_deliverMessage(event);
		}
	}

	void host_deliverMessage(kom.itbeankit.common.message.MessageEvent event)
	{
		deliverMessage(event);
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == helpButton)
				helpButton_ActionPerformed(event);
		}
	}

	void helpButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		deliverMessage(new MessageEvent(this,
		                                MessageEvent.DISPLAY_TYPE_DIALOG,
		                                MessageEvent.MSG_TYPE_INFO,
		                                EthernetTexts.EFFICIENCY_LABEL,
		                                EthernetTexts.EFFICIENCY_HELP));
	}





	class SymData implements kom.itbeankit.nw.ethernet.DataListener
	{
		public void dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == hub1)
				hub1_dataToRight(event);
			else if (object == hub2)
				hub2_dataToRight(event);
		}

		public void dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == hub1)
				hub1_dataToTop(event);
			else if (object == hub2)
				hub2_dataToTop(event);
			else if (object == host2)
				host2_dataToTop(event);
			else if (object == host4)
				host4_dataToTop(event);
			else if (object == host6)
				host6_dataToTop(event);
		}

		public void dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			/*if (object == host2)
				host2_dataToBottom(event);
			else*/ if (object == host3)
				host3_dataToBottom(event);
			else if (object == host5)
				host5_dataToBottom(event);
			/*else if (object == host6)
				host6_dataToBottom(event);*/
			else if (object == host1)
				host1_dataToBottom(event);
			/*else if (object == host4)
				host4_dataToBottom(event);*/
			else if (object == hub1)
				hub1_dataToBottom(event);
			else if (object == hub2)
				hub2_dataToBottom(event);
		}

		public void dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == hub2)
				hub2_dataToLeft(event);
			else if (object == hub1)
				hub1_dataToLeft(event);
		}
	}

	void host2_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFrombottom...
		{
			hub1.dataFromBottom(event);
		}
		//}}
	}


	void host3_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			hub1.dataFromTop(event);
		}
		//}}
	}

	void host5_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			hub2.dataFromTop(event);
		}
		//}}
	}

	void host6_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromRight...
		{
			hub2.dataFromRight(event);
		}
		//}}
	}

	void host1_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromLeft...
		{
			hub1.dataFromLeft(event);
		}
		//}}
	}

	void host4_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			hub2.dataFromBottom(event);
		}
		//}}
	}

	void hub1_dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromLeft...
		{
			hub2.dataFromLeft(event);
		}
		//}}
	}

	void hub2_dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromLeft...
		{
			hub1.dataFromRight(event);
		}
		//}}
	}

	void hub1_dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host1.dataFromTop(event);
		}
		//}}
	}

	void hub2_dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host6.dataFromTop(event);
		}
		//}}
	}

	void hub1_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host3.dataFromBottom(event);
		}
		//}}
	}

	void hub2_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host5.dataFromBottom(event);
		}
		//}}
	}

	void hub1_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host2.dataFromTop(event);
		}
		//}}
	}

	void hub2_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host4.dataFromTop(event);
		}
		//}}
	}
}